package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.CnaeJ73;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * CnaeJ73DaoImpl generated by UDA, 27-jul-2016 11:29:27.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class CnaeJ73DaoImpl implements CnaeJ73Dao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<CnaeJ73> rwMap = new RowMapper<CnaeJ73>() {
		public CnaeJ73 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			CnaeJ73 ramaRet = new CnaeJ73(resultSet.getString("SECC003"),
					resultSet.getString("DIVI003"),
					resultSet.getString("GRUP003"),
					resultSet.getString("CLAS003"),
					resultSet.getString("CNAE003") + "-"
							+ resultSet.getString("DESC003"));
			ramaRet.setCnae003(resultSet.getString("CNAE003"));

			return ramaRet;
		}
	};

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<CnaeJ73> rwMapCnae = new RowMapper<CnaeJ73>() {
		public CnaeJ73 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			CnaeJ73 ramaRet = new CnaeJ73(resultSet.getString("SECC003"),
					resultSet.getString("DIVI003"),
					resultSet.getString("GRUP003"),
					resultSet.getString("CLAS003"),
					resultSet.getString("DESC003"));
			ramaRet.setCnae003(resultSet.getString("CNAE003"));

			return ramaRet;
		}
	};

	private RowMapper<CnaeJ73> rwMapAutoComp = new RowMapper<CnaeJ73>() {
		public CnaeJ73 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			CnaeJ73 ramaRet = new CnaeJ73(resultSet.getString("SECC003"),
					resultSet.getString("DIVI003"),
					resultSet.getString("GRUP003"),
					resultSet.getString("CLAS003"),
					resultSet.getString("DESC003"));
			ramaRet.setCnae003(resultSet.getString("CNAE003") + "_"
					+ resultSet.getString("SECC003"));

			return ramaRet;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a single row in the CnaeJ73 table.
	 * 
	 *  cnaej73
	 *            CnaeJ73
	 *  CnaeJ73
	 *
	 * @param cnaej73 the cnaej 73
	 * @return the cnae J 73
	 */
	@Transactional(readOnly = true)
	public CnaeJ73 find(CnaeJ73 cnaej73) {
		String query = "SELECT t1.SECC_003 SECC003, t1.DIVI_003 DIVI003, t1.GRUP_003 GRUP003, t1.CLAS_003 CLAS003, t1.DESC_003 DESC003 FROM VCNAEJ73 t1  WHERE t1.SECC_003 = ?   AND t1.DIVI_003 = ?   AND t1.GRUP_003 = ?   AND t1.CLAS_003 = ?   AND t1.DESC_003 = ?  ";

		List<CnaeJ73> cnaej73List = this.jdbcTemplate.query(query, this.rwMap,
				cnaej73.getSecc003(), cnaej73.getDivi003(),
				cnaej73.getGrup003(), cnaej73.getClas003(),
				cnaej73.getDesc003());
		return (CnaeJ73) DataAccessUtils.uniqueResult(cnaej73List);
	}

	/**
	 * Finds a list of rows in the CnaeJ73 table.
	 * 
	 *  cnaej73
	 *            CnaeJ73
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<CnaeJ73>
	 *
	 * @param cnaej73 the cnaej 73
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<CnaeJ73> findAll(CnaeJ73 cnaej73,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SECC_003 SECC003,t1.DIVI_003 DIVI003,t1.GRUP_003 GRUP003,t1.CLAS_003 CLAS003,t1.DESC_003 DESC003, t1.CNAE_003 CNAE003 ");
		query.append("FROM VCNAEJ73 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(cnaej73);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<CnaeJ73>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Obtiene las cnaej73 principales (de primer nivel).
	 * 
	 *  cnaej73            Vcnaej73
	 *  List<Vcnaej73>
	 *
	 * @param cnaej73 the cnaej 73
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<CnaeJ73> findAllNivelSuperior(CnaeJ73 cnaej73) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SECC_003 SECC003,t1.DIVI_003 DIVI003,t1.GRUP_003 GRUP003,t1.CLAS_003 CLAS003,t1.DESC_003 DESC003,t1.CNAE_003 CNAE003 ");
		query.append(
				"FROM VCNAEJ73 t1 WHERE TRIM(t1.GRUP_003) IS NULL AND TRIM(t1.CLAS_003) IS NULL AND t1.SECC_003=?");

		// Where clause & Params
		return (List<CnaeJ73>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, cnaej73.getSecc003());
	}

	/**
	 * Obtiene las cnaej73 de una seccion.
	 * 
	 *  cnaej73            Vcnaej73
	 *  List<Vcnaej73>
	 *
	 * @param cnaej73 the cnaej 73
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<CnaeJ73> findAllBySeccion(CnaeJ73 cnaej73) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SECC_003 SECC003,t1.DIVI_003 DIVI003,t1.GRUP_003 GRUP003,t1.CLAS_003 CLAS003,t1.DESC_003 DESC003,t1.CNAE_003 CNAE003 ");
		query.append("FROM VCNAEJ73 t1 WHERE t1.SECC_003=?");

		// Where clause & Params
		return (List<CnaeJ73>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, cnaej73.getSecc003());
	}

	/**
	 * Obtiene las cnaej73 de una CNAE.
	 * 
	 *  cnaej73            Vcnaej73
	 *  List<Vcnaej73>
	 *
	 * @param cnaej73 the cnaej 73
	 * @return the cnae J 73
	 */
	@Transactional(readOnly = true)
	public CnaeJ73 findByCnae(CnaeJ73 cnaej73) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SECC_003 SECC003,t1.DIVI_003 DIVI003,t1.GRUP_003 GRUP003,t1.CLAS_003 CLAS003,t1.DESC_003 DESC003,t1.CNAE_003 CNAE003 ");
		query.append("FROM VCNAEJ73 t1 WHERE t1.CNAE_003=?");

		// Where clause & Params
		List<CnaeJ73> cnaej73List;

		if (cnaej73.getSecc003() != null) {
			query.append("AND t1.SECC_003=?");

			// Where clause & Params
			cnaej73List = this.jdbcTemplate.query(query.toString(),
					this.rwMapCnae, cnaej73.getCnae003(), cnaej73.getSecc003());
		} else {
			// Where clause & Params
			cnaej73List = this.jdbcTemplate.query(query.toString(),
					this.rwMapCnae, cnaej73.getCnae003());
		}

		return (CnaeJ73) DataAccessUtils.uniqueResult(cnaej73List);
	}

	/**
	 * Finds rows in the CnaeJ73 table using like.
	 * 
	 *  cnaej73
	 *            CnaeJ73
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<CnaeJ73>
	 *
	 * @param cnaej73 the cnaej 73
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<CnaeJ73> findAllLike(CnaeJ73 cnaej73,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SECC_003 SECC003,t1.DIVI_003 DIVI003,t1.GRUP_003 GRUP003,t1.CLAS_003 CLAS003,t1.DESC_003 DESC003,t1.CNAE_003 CNAE003 ");
		query.append("FROM VCNAEJ73 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(cnaej73, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<CnaeJ73>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the CnaeJ73 table using like.
	 * 
	 *  cnaej73
	 *            CnaeJ73
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<CnaeJ73>
	 *
	 * @param cnaej73 the cnaej 73
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<CnaeJ73> findAllForAutocomplete(CnaeJ73 cnaej73,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.SECC_003 SECC003,t1.DIVI_003 DIVI003,t1.GRUP_003 GRUP003,t1.CLAS_003 CLAS003,t1.DESC_003 DESC003,t1.CNAE_003 CNAE003 ");
		query.append("FROM VCNAEJ73 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(cnaej73, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<CnaeJ73>) this.jdbcTemplate.query(query.toString(),
				this.rwMapAutoComp, params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the CnaeJ73 entity.
	 * 
	 *  cnaej73            CnaeJ73 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param cnaej73 the cnaej 73
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(CnaeJ73 cnaej73) {

		StringBuilder where = new StringBuilder(
				CnaeJ73DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (cnaej73 != null && cnaej73.getSecc003() != null) {
			where.append(" AND t1.SECC_003 = ?");
			params.add(cnaej73.getSecc003());
		}
		if (cnaej73 != null && cnaej73.getDivi003() != null) {
			where.append(" AND t1.DIVI_003 = ?");
			params.add(cnaej73.getDivi003());
		}
		if (cnaej73 != null && cnaej73.getGrup003() != null) {
			where.append(" AND t1.GRUP_003 = ?");
			params.add(cnaej73.getGrup003());
		}
		if (cnaej73 != null && cnaej73.getClas003() != null) {
			where.append(" AND t1.CLAS_003 = ?");
			params.add(cnaej73.getClas003());
		}
		if (cnaej73 != null && cnaej73.getDesc003() != null) {
			where.append(" AND t1.DESC_003 = ?");
			params.add(cnaej73.getDesc003());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the CnaeJ73 entity.
	 * 
	 *  cnaej73            CnaeJ73 Bean with the criteria values to filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param cnaej73 the cnaej 73
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(CnaeJ73 cnaej73,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				CnaeJ73DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (cnaej73 != null && cnaej73.getSecc003() != null) {
			where.append(" AND UPPER(t1.SECC_003) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(cnaej73.getSecc003().toUpperCase() + "%");
			} else {
				params.add("%" + cnaej73.getSecc003().toUpperCase() + "%");
			}
			where.append(" AND t1.SECC_003 IS NOT NULL");
		}
		if (cnaej73 != null && cnaej73.getDivi003() != null) {
			where.append(" AND UPPER(t1.DIVI_003) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(cnaej73.getDivi003().toUpperCase() + "%");
			} else {
				params.add("%" + cnaej73.getDivi003().toUpperCase() + "%");
			}
			where.append(" AND t1.DIVI_003 IS NOT NULL");
		}
		if (cnaej73 != null && cnaej73.getGrup003() != null) {
			where.append(" AND UPPER(t1.GRUP_003) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(cnaej73.getGrup003().toUpperCase() + "%");
			} else {
				params.add("%" + cnaej73.getGrup003().toUpperCase() + "%");
			}
			where.append(" AND t1.GRUP_003 IS NOT NULL");
		}
		if (cnaej73 != null && cnaej73.getClas003() != null) {
			where.append(" AND UPPER(t1.CLAS_003) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(cnaej73.getClas003().toUpperCase() + "%");
			} else {
				params.add("%" + cnaej73.getClas003().toUpperCase() + "%");
			}
			where.append(" AND t1.CLAS_003 IS NOT NULL");
		}
		if (cnaej73 != null && cnaej73.getDesc003() != null) {
			where.append(" AND UPPER(t1.DESC_003) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(cnaej73.getDesc003().toUpperCase() + "%");
			} else {
				params.add("%" + cnaej73.getDesc003().toUpperCase() + "%");
			}
			where.append(" AND t1.DESC_003 IS NOT NULL");
		}

		if (cnaej73 != null && cnaej73.getCnae003() != null) {
			where.append(" AND UPPER(t1.CNAE_003) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(cnaej73.getCnae003().toUpperCase() + "%");
			} else {
				params.add("%" + cnaej73.getCnae003().toUpperCase() + "%");
			}
			where.append(" AND t1.CNAE_003 IS NOT NULL");
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
